(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13998,        545]*)
(*NotebookOutlinePosition[     14953,        576]*)
(*  CellTagsIndexPosition[     14909,        572]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ShowCellLabel->False,
  ImageSize->{200, 200},
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  PageHeaderLines->{True, True},
  PrintingOptions->{"FirstPageHeader"->False,
  "FacingPages"->True},
  CellLabelAutoDelete->False,
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{18, 30}, {4, 20}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->9,
  LineSpacing->{0.95, 0},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->36],

Cell[StyleData["Title", "Printout"],
  CellMargins->{{18, 30}, {4, 0}},
  CellFrameMargins->4,
  FontSize->30]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{18, 30}, {0, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  LineSpacing->{1, 0},
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->24,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{18, 30}, {0, 10}},
  FontSize->18]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SectionFirst"],
  CellFrame->{{0, 0}, {0, 3}},
  CellMargins->{{18, 30}, {4, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->3,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["SectionFirst", "Printout"],
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellMargins->{{18, 30}, {4, 30}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Printout"],
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSquare]",
  CellMargins->{{18, 30}, {4, 20}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"],
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{18, 30}, {4, 12}},
  CellGroupingRules->{"SectionGrouping", 60},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Printout"],
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{18, 10}, {Inherited, 6}},
  TextJustification->1,
  LineSpacing->{1, 2},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  LineSpacing->{1, 3},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Caption"],
  CellMargins->{{55, 50}, {5, 5}},
  PageBreakAbove->False,
  FontSize->10],

Cell[StyleData["Caption", "Printout"],
  CellMargins->{{55, 55}, {5, 2}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{55, 10}, {5, 8}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{55, 55}, {0, 10}},
  ShowCellLabel->False,
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{55, 10}, {8, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelPositioning->Left,
  CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{55, 55}, {10, 10}},
  ShowCellLabel->False,
  FontSize->9.5]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{55, 55}, {0, 3}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{26, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{54, 72}, {2, 10}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{55, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Printout"],
  CellMargins->{{55, 55}, {0, 15}},
  ImageSize->{0.0625, 0.0625},
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  CellMargins->{{9, Inherited}, {Inherited, Inherited}},
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontSlant->"Oblique"],

Cell[StyleData["CellLabel", "Printout"],
  CellMargins->{{0, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Unique Styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Author"],
  CellMargins->{{45, Inherited}, {2, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Author", "Printout"],
  CellMargins->{{36, Inherited}, {2, 30}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Address"],
  CellMargins->{{45, Inherited}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 30},
  PageBreakBelow->False,
  LineSpacing->{1, 1},
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontSize->12,
  FontSlant->"Italic"],

Cell[StyleData["Address", "Printout"],
  CellMargins->{{36, Inherited}, {2, 2}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Abstract"],
  CellMargins->{{45, 75}, {Inherited, 30}},
  LineSpacing->{1, 0}],

Cell[StyleData["Abstract", "Printout"],
  CellMargins->{{36, 67}, {Inherited, 50}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Reference"],
  CellMargins->{{18, 40}, {2, 2}},
  TextJustification->1,
  LineSpacing->{1, 0}],

Cell[StyleData["Reference", "Printout"],
  CellMargins->{{18, 40}, {Inherited, 0}},
  FontSize->8]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Automatic Numbering", "Section"],

Cell["\<\
The following styles are useful for numbered equations, figures, \
etc.  They automatically give the cell a FrameLabel containing a reference to \
a particular counter, and also increment that counter.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["NumberedEquation"],
  CellMargins->{{55, 10}, {0, 10}},
  CellFrameLabels->{{None, Cell[ 
          TextData[ {"(", 
            CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
  DefaultFormatType->DefaultInputFormatType,
  CounterIncrements->"NumberedEquation",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedEquation", "Printout"],
  CellMargins->{{55, 55}, {0, 10}},
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedFigure"],
  CellMargins->{{55, 145}, {2, 10}},
  CellHorizontalScrolling->True,
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Figure ", 
            CounterBox[ "NumberedFigure"]}], FontWeight -> "Bold"], None}},
  CounterIncrements->"NumberedFigure",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedFigure", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["NumberedTable"],
  CellMargins->{{55, 145}, {2, 10}},
  CellFrameLabels->{{None, None}, {Cell[ 
          TextData[ {"Table ", 
            CounterBox[ "NumberedTable"]}], FontWeight -> "Bold"], None}},
  TextAlignment->Center,
  CounterIncrements->"NumberedTable",
  FormatTypeAutoConvert->False],

Cell[StyleData["NumberedTable", "Printout"],
  CellMargins->{{18, Inherited}, {Inherited, Inherited}},
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{55, 10}, {2, 10}},
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  ScriptLevel->0,
  SingleLetterItalics->True,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["ChemicalFormula"],
  CellMargins->{{55, 10}, {2, 10}},
  DefaultFormatType->DefaultInputFormatType,
  AutoSpacing->False,
  ScriptLevel->1,
  ScriptBaselineShifts->{0.6, Automatic},
  SingleLetterItalics->False,
  ZeroWidthTimes->True],

Cell[StyleData["ChemicalFormula", "Printout"],
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Program"],
  CellMargins->{{18, 10}, {Inherited, 6}},
  FontFamily->"Courier"],

Cell[StyleData["Program", "Printout"],
  CellMargins->{{18, 30}, {Inherited, 4}},
  FontSize->9.5]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{479, 297},
WindowMargins->{{10, Automatic}, {Automatic, 4}},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->True,
"FacingPages"->True,
"FirstPageFace"->Right},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 52, "Subtitle"],
Cell[1771, 53, 193, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 42, 0, 50, "Section"],
Cell[2034, 64, 51, 1, 70, 31, 0, "StyleData", "All", "Working"],
Cell[2088, 67, 153, 4, 70, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2278, 76, 35, 0, 30, "Section"],
Cell[2316, 78, 101, 3, 30, "Text"],
Cell[2420, 83, 559, 15, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3016, 103, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3079, 107, 329, 9, 85, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3411, 118, 110, 3, 70, 36, 0, "StyleData", "Title", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3558, 126, 299, 8, 52, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[3860, 136, 91, 2, 70, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[3988, 143, 327, 9, 56, 31, 0, "StyleData", "SectionFirst", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4318, 154, 59, 1, 70, 43, 0, "StyleData", "SectionFirst", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4414, 160, 268, 7, 50, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[4685, 169, 54, 1, 70, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[4776, 175, 289, 8, 46, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[5068, 185, 57, 1, 70, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5162, 191, 254, 7, 45, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[5419, 200, 60, 1, 36, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5528, 207, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[5592, 211, 142, 4, 38, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[5737, 217, 117, 3, 35, 35, 0, "StyleData", "Text", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5891, 225, 102, 3, 36, 26, 0, "StyleData", "Caption", "All"],
Cell[5996, 230, 88, 2, 31, 38, 0, "StyleData", "Caption", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6133, 238, 42, 0, 30, "Section"],
Cell[6178, 240, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[6451, 249, 483, 15, 42, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[6937, 266, 113, 3, 36, 36, 0, "StyleData", "Input", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7087, 274, 484, 14, 48, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[7574, 290, 115, 3, 47, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7726, 298, 538, 16, 42, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[8267, 316, 88, 2, 27, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[8392, 323, 521, 15, 44, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[8916, 340, 87, 2, 36, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9040, 347, 389, 11, 44, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[9432, 360, 172, 4, 39, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9641, 369, 177, 5, 43, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[9821, 376, 112, 2, 32, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9982, 384, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[10039, 388, 247, 6, 52, 25, 0, "StyleData", "Author", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[10289, 396, 96, 2, 61, 37, 0, "StyleData", "Author", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10422, 403, 271, 7, 35, 26, 0, "StyleData", "Address", "All",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[10696, 412, 96, 2, 30, 38, 0, "StyleData", "Address", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[10829, 419, 94, 2, 36, 27, 0, "StyleData", "Abstract", "All"],
Cell[10926, 423, 99, 2, 81, 39, 0, "StyleData", "Abstract", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[11062, 430, 110, 3, 34, 28, 0, "StyleData", "Reference", "All"],
Cell[11175, 435, 98, 2, 26, 40, 0, "StyleData", "Reference", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11322, 443, 49, 0, 30, "Section"],
Cell[11374, 445, 225, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[11624, 453, 319, 7, 38, 35, 0, "StyleData", "NumberedEquation", "All",
  CounterIncrements->"NumberedEquation"],
Cell[11946, 462, 99, 2, 37, 47, 0, "StyleData", "NumberedEquation", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12082, 469, 325, 7, 55, 33, 0, "StyleData", "NumberedFigure", "All",
  CounterIncrements->"NumberedFigure"],
Cell[12410, 478, 61, 1, 57, 45, 0, "StyleData", "NumberedFigure", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12508, 484, 313, 7, 55, 32, 0, "StyleData", "NumberedTable", "All",
  CounterIncrements->"NumberedTable"],
Cell[12824, 493, 118, 2, 55, 44, 0, "StyleData", "NumberedTable", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12991, 501, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[13059, 505, 250, 6, 40, 33, 0, "StyleData", "DisplayFormula", "All"],
Cell[13312, 513, 61, 1, 36, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13410, 519, 251, 7, 34, 34, 0, "StyleData", "ChemicalFormula", "All"],
Cell[13664, 528, 62, 1, 39, 46, 0, "StyleData", "ChemicalFormula", "Printout"]

}, Closed]],

Cell[CellGroupData[{
Cell[13763, 534, 94, 2, 36, 26, 0, "StyleData", "Program", "All"],
Cell[13860, 538, 98, 2, 35, 38, 0, "StyleData", "Program", "Printout"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

